#!/c/Perl/bin//perl -w
#
# $Id: gcnmz-1.pl.in,v 1.1.4.2 2006/01/10 19:37:18 opengl2772 Exp $
# Copyright (C) 2004-2006 Tadamasa Teranishi
#               2004-2006 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# Test for gcnmz.
#

use strict;
require Cwd;
use File::Copy;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";
my $TARGET = pltests::selectdata();
my $INDEX4 = "$cwd/idx4";
my $INDEX = "$cwd/idx5";
my $INDEX6 = "$cwd/idx6";
my $TMPDATA = "$cwd/tmp-data";
my $MKNMZ = pltests::binpath('mknmz');
my $GCNMZ = pltests::binpath('gcnmz');

my @cmd;

pltests::putline($LOG, "  *** starting $0");

if (-d "$INDEX") {
    unlink(<$INDEX/NMZ.*>);
} else {
    mkdir("$INDEX", 0755);
}
if (-d "$INDEX6") {
    unlink(<$INDEX6/NMZ.*>);
} else {
    mkdir("$INDEX6", 0755);
}
# Copy idx4 for testing gcnmz.
for my $file (<$INDEX4/*>) {
    copy($file, $INDEX6);
}

# Copy docments.
if (-d "$TMPDATA") {
    unlink(<$TMPDATA/*>);
} else {
    mkdir("$TMPDATA", 0755);
}
for my $file (<$TARGET/*>) {
    copy($file, $TMPDATA);
}

# Remove some documents.
unlink(<$TMPDATA/*.txt>);

# Simple indexing to make a reference index.
@cmd = ("$MKNMZ", "-O", "$INDEX", "$TMPDATA");
pltests::putline($LOG, "  ", \@cmd);
my $status = pltests::logsyscmd($LOG, \@cmd);
if ($status != 0) {
    exit 1;
}

# Apply gcnmz for idx6.
@cmd = ("$GCNMZ", "--quiet", "--no-backup", "$INDEX6");
pltests::putline($LOG, "  ", \@cmd);
$status = pltests::logsyscmd($LOG, \@cmd);
if ($status != 0) {
    exit 1;
}

exit 0;
